class u4e_DMstats expands Mutator config(TS_Database);

//Database variables:
var config string	Nick[2048];
var config int		Score[2048],
			Deaths[2048],
			LongestSpree[2048],
			Headshots[2048];

//Temp variables:
var string 	names[32];
var int 	oldHS[32],
		oldSpree[32];
var bool	bInit;

function bool HandleEndGame()
{

	Super.HandleEndGame();

	if ( !bInit )
		{
		UpdateDB();
		SaveConfig();
		}

	bInit = True;

}

function UpdateDB()
{
local Pawn P;
local int i;
local Inventory Inv;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn'))
			{
			for (i=0;i<2048;i++)
				{
				if ( Nick[i] == P.PlayerReplicationInfo.PlayerName || Nick[i] == "" )
					{
					Nick[i] = P.PlayerReplicationInfo.PlayerName;
					Score[i] += P.PlayerReplicationInfo.Score;
					Deaths[i] += P.PlayerReplicationInfo.Deaths;
					for( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
						{ 
						if ( Inv.IsA('PlayerItem') )
							{
							LongestSpree[i] = PlayerItem(inv).MaxSpree;
							HeadShots[i] += PlayerItem(inv).Headshots;
							}
						}
					i=100000;
					}
				}
			}
		}
}

function GrabDBvars(Pawn Player)
{
local Pawn P;
local int i;
local Inventory Inv;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P == Player )
			{
			for (i=0;i<2048;i++)
				{
				if ( Nick[i] == Player.PlayerReplicationInfo.PlayerName || Nick[i] == "" )
					{
					Nick[i] = Player.PlayerReplicationInfo.PlayerName;
					for( Inv=Player.Inventory; Inv!=None; Inv=Inv.Inventory )
						{ 
						if ( Inv.IsA('PlayerItem') )
							{
							PlayerItem(inv).MaxSpree = LongestSpree[i];
							PlayerItem(inv).TotalHeadshots = Headshots[i];
							PlayerItem(inv).TotalScore = Score[i];
							PlayerItem(inv).TotalDeaths = Deaths[i];
							}
						}
					i=100000;
					}
				}
			}
		}
}

function Timer()
{
local Pawn P;
local Inventory Inv;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn'))
			{
			for( Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory )
				{ 
				if ( Inv.IsA('PlayerItem') )
					{
					if ( !PlayerItem(Inv).bInitialCheck )
						{
						GrabDBvars(P);
						PlayerItem(Inv).bInitialCheck = True;
						}
					}
				}
			}
		}
}

function PreBeginPlay ()
{
	Super.PreBeginPlay();

	settimer(0.5, true);
}

function ModifyPlayer(Pawn Other)
{
local Inventory Inv;
local int i;

	if ( Other.IsA('PlayerPawn') )
		{
		inv = Spawn(class'PlayerItem');
		if( inv != None )
			{
			for (i=0;i<32;i++)
				{
				if ( names[i] == Other.PlayerReplicationInfo.PlayerName || names[i] == "" )
					{
					PlayerItem(inv).Headshots = oldHS[i];
					PlayerItem(inv).MaxSpree = oldSpree[i];
					names[i] = "";
					}
				}
			inv.GiveTo(Other);
      			}
		}

   if ( NextMutator != None )
      NextMutator.ModifyPlayer(Other);
}

function bool PreventDeath(Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local Inventory Inv;
local int i;

	if ( DamageType == 'Decapitated' && Killer.IsA('PlayerPawn') )
		{
		for( Inv=Killer.Inventory; Inv!=None; Inv=Inv.Inventory )
			{ 
			if ( Inv.IsA('PlayerItem') )
				{
				PlayerItem(Inv).Headshots++;
				PlayerItem(Inv).Spree++;
				for (i=0;i<32;i++)
					{
					if ( names[i] == Killer.PlayerReplicationInfo.PlayerName || names[i] == "" )
						{
						oldHS[i] = PlayerItem(inv).Headshots;
						names[i] = Killer.PlayerReplicationInfo.PlayerName;
						if ( PlayerItem(Inv).Spree > PlayerItem(Inv).MaxSpree )
							{
							oldSpree[i] = PlayerItem(inv).Spree;
							PlayerItem(Inv).MaxSpree = PlayerItem(Inv).Spree;
							//broadcast new spree record
							Killer.ReceiveLocalizedMessage( class'MaxSpreeMessage' );
							}
						}
					}
				}
			}
		}
	else
		{
		for( Inv=Killer.Inventory; Inv!=None; Inv=Inv.Inventory )
			{ 
			if ( Inv.IsA('PlayerItem') )
				{
				PlayerItem(Inv).Spree++;
				if ( PlayerItem(Inv).Spree > PlayerItem(Inv).MaxSpree )
						{
						PlayerItem(Inv).MaxSpree = PlayerItem(Inv).Spree;
						//broadcast new spree record
						Killer.ReceiveLocalizedMessage( class'MaxSpreeMessage' );
						}
				}
			}
		}
	for( Inv=Killed.Inventory; Inv!=None; Inv=Inv.Inventory )
		{ 
		if ( Inv.IsA('PlayerItem') )
			{
			for (i=0;i<32;i++)
				{
				if ( names[i] == Killed.PlayerReplicationInfo.PlayerName || names[i] == "" )
					{
					oldHS[i] = PlayerItem(inv).Headshots;
					names[i] = Killed.PlayerReplicationInfo.PlayerName;
					if ( PlayerItem(Inv).Spree > PlayerItem(Inv).MaxSpree )
							{
							oldSpree[i] = PlayerItem(inv).Spree;
							}
					else
							{
							oldSpree[i] = PlayerItem(inv).MaxSpree;
							}
					}
				}
			}
		}

	if ( NextMutator != None )
		return NextMutator.PreventDeath(Killed,Killer, damageType,HitLocation);
	return false;
}

defaultproperties
{
}


